/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.AmbientLightRetained;
import javax.media.j3d.BackgroundRetained;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.EnvironmentSet;
import javax.media.j3d.LightRetained;
import javax.media.j3d.ObjectUpdate;
import javax.media.j3d.OrderedCollection;
import javax.media.j3d.PointLightRetained;
import javax.media.j3d.RenderBin;
import javax.media.j3d.VirtualUniverse;

class LightBin
implements ObjectUpdate {
    int maxLights = -1;
    LightRetained[] lights = null;
    int[] lightsRef = null;
    int numEmptySlots = -1;
    RenderBin renderBin = null;
    LightBin next = null;
    LightBin prev = null;
    EnvironmentSet environmentSetList = null;
    ArrayList insertEnvSet = new ArrayList();
    int canvasDirty = 0;
    int lightDirtyMaskCache = 0;
    int lightDirtyMask = 0;
    ArrayList pointLts = new ArrayList();
    int[] pointLtsSlotIndex;
    OrderedCollection orderedCollection = null;
    boolean onUpdateList = false;
    BackgroundRetained geometryBackground = null;

    LightBin(int n2, RenderBin renderBin, boolean bl) {
        this.maxLights = n2;
        this.numEmptySlots = n2;
        this.lights = new LightRetained[n2];
        this.lightsRef = new int[n2];
        this.renderBin = renderBin;
    }

    void reset(boolean bl) {
        this.prev = null;
        this.next = null;
        this.orderedCollection = null;
        this.environmentSetList = null;
        this.onUpdateList = false;
        this.geometryBackground = null;
    }

    void setOrderedInfo(OrderedCollection orderedCollection) {
        this.orderedCollection = orderedCollection;
    }

    boolean willEnvironmentSetFit(EnvironmentSet environmentSet) {
        int n2;
        int n3 = n2 = environmentSet.lights.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(i2);
            if (lightRetained instanceof AmbientLightRetained) continue;
            for (int i3 = 0; i3 < this.maxLights; ++i3) {
                if (this.lights[i3] != lightRetained) continue;
                --n3;
                continue block0;
            }
        }
        return n3 <= this.numEmptySlots;
    }

    void addEnvironmentSet(EnvironmentSet environmentSet, RenderBin renderBin) {
        int n2 = environmentSet.lights.size();
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            int n3;
            LightRetained lightRetained = (LightRetained)environmentSet.lights.get(i2);
            if (lightRetained instanceof AmbientLightRetained) continue;
            for (n3 = 0; n3 < this.maxLights; ++n3) {
                if (this.lights[n3] != lightRetained) continue;
                if (lightRetained.lightOn) {
                    environmentSet.enableMask |= (long)(1 << n3);
                }
                int n4 = n3;
                this.lightsRef[n4] = this.lightsRef[n4] + 1;
                environmentSet.ltPos[i2] = n3;
                break;
            }
            if (n3 != this.maxLights) continue;
            for (n3 = 0; n3 < this.maxLights; ++n3) {
                if (this.lights[n3] != null) continue;
                this.lights[n3] = lightRetained;
                this.lightsRef[n3] = 1;
                if (lightRetained instanceof PointLightRetained) {
                    this.pointLts.add(lightRetained);
                    int n5 = 0;
                    if (this.pointLtsSlotIndex != null) {
                        n5 = this.pointLtsSlotIndex.length;
                    }
                    if (n5 < this.pointLts.size()) {
                        int[] nArray = new int[n5 + 8];
                        for (int i3 = 0; i3 < n5; ++i3) {
                            nArray[i3] = this.pointLtsSlotIndex[i3];
                        }
                        this.pointLtsSlotIndex = nArray;
                    }
                    this.pointLtsSlotIndex[this.pointLts.size() - 1] = n3;
                }
                if (lightRetained.lightOn) {
                    environmentSet.enableMask |= (long)(1 << n3);
                }
                environmentSet.ltPos[i2] = n3;
                --this.numEmptySlots;
                continue block0;
            }
        }
        environmentSet.lightBin = this;
        environmentSet.enableMaskCache = environmentSet.enableMask;
        this.insertEnvSet.add(environmentSet);
        if (!this.onUpdateList) {
            renderBin.objUpdateList.add(this);
            this.onUpdateList = true;
        }
    }

    public void updateObject() {
        int n2;
        if (this.insertEnvSet.size() > 0) {
            EnvironmentSet environmentSet = (EnvironmentSet)this.insertEnvSet.get(0);
            if (this.environmentSetList == null) {
                this.environmentSetList = environmentSet;
            } else {
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
            for (n2 = 1; n2 < this.insertEnvSet.size(); ++n2) {
                environmentSet = (EnvironmentSet)this.insertEnvSet.get(n2);
                environmentSet.next = this.environmentSetList;
                this.environmentSetList.prev = environmentSet;
                this.environmentSetList = environmentSet;
            }
        }
        this.insertEnvSet.clear();
        if (this.canvasDirty != 0) {
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            for (n2 = 0; n2 < canvas3DArray.length; ++n2) {
                canvas3DArray[n2].canvasDirty |= this.canvasDirty;
            }
            this.lightDirtyMask = this.lightDirtyMaskCache;
            this.canvasDirty = 0;
            this.lightDirtyMaskCache = 0;
        }
        this.onUpdateList = false;
    }

    void removeEnvironmentSet(EnvironmentSet environmentSet) {
        environmentSet.lightBin = null;
        if (this.insertEnvSet.contains(environmentSet)) {
            this.insertEnvSet.remove(this.insertEnvSet.indexOf(environmentSet));
        } else {
            int n2;
            int n3 = environmentSet.lights.size();
            block0: for (n2 = 0; n2 < n3; ++n2) {
                LightRetained lightRetained = (LightRetained)environmentSet.lights.get(n2);
                for (int i2 = 0; i2 < this.maxLights; ++i2) {
                    if (this.lights[i2] != lightRetained) continue;
                    int n4 = i2;
                    this.lightsRef[n4] = this.lightsRef[n4] - 1;
                    if (this.lightsRef[i2] != 0) continue block0;
                    if (lightRetained instanceof PointLightRetained) {
                        this.pointLts.remove(this.pointLts.indexOf(lightRetained));
                    }
                    this.lights[i2] = null;
                    this.lightDirtyMaskCache &= ~(1 << i2);
                    this.lightDirtyMask &= ~(1 << i2);
                    ++this.numEmptySlots;
                    continue block0;
                }
            }
            if (environmentSet.prev == null) {
                this.environmentSetList = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = null;
                }
            } else {
                environmentSet.prev.next = environmentSet.next;
                if (environmentSet.next != null) {
                    environmentSet.next.prev = environmentSet.prev;
                }
            }
            Canvas3D[] canvas3DArray = this.renderBin.view.getCanvases();
            for (n2 = 0; n2 < canvas3DArray.length; ++n2) {
                canvas3DArray[n2].environmentSet = null;
            }
        }
        environmentSet.prev = null;
        environmentSet.next = null;
        if (this.environmentSetList == null && this.insertEnvSet.size() == 0) {
            this.renderBin.removeLightBin(this);
            this.geometryBackground = null;
        }
    }

    void render(Canvas3D canvas3D) {
        canvas3D.setStateToUpdate(0, this);
        EnvironmentSet environmentSet = this.environmentSetList;
        while (environmentSet != null) {
            environmentSet.render(canvas3D);
            environmentSet = environmentSet.next;
        }
    }

    void updateAttributes(Canvas3D canvas3D) {
        int n2 = VirtualUniverse.mc.frameCount;
        if (canvas3D.lightBin != this) {
            double d2;
            if (this.geometryBackground == null) {
                d2 = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d2 = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i2 = 0; i2 < this.maxLights; ++i2) {
                if (this.lights[i2] == null || canvas3D.lights[i2] == this.lights[i2] && canvas3D.frameCount[i2] == n2) continue;
                canvas3D.lights[i2] = this.lights[i2];
                canvas3D.frameCount[i2] = n2;
                this.lights[i2].update(canvas3D.ctx, i2, d2);
            }
            canvas3D.lightBin = this;
            canvas3D.canvasDirty &= 0xFFFFFFBF;
            canvas3D.enableMask = -1L;
        } else if ((canvas3D.canvasDirty & 0x40) != 0) {
            double d3;
            if (this.geometryBackground == null) {
                d3 = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d3 = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            int n3 = 0;
            int n4 = this.lightDirtyMask;
            while (n4 != 0) {
                if ((n4 & 1) != 0) {
                    this.lights[n3].update(canvas3D.ctx, n3, d3);
                    canvas3D.lights[n3] = this.lights[n3];
                    canvas3D.frameCount[n3] = n2;
                }
                n4 >>= 1;
                ++n3;
            }
            canvas3D.canvasDirty &= 0xFFFFFFBF;
        } else if (this.pointLts.size() > 0 && (canvas3D.canvasDirty & 0x8000) != 0) {
            double d4;
            if (this.geometryBackground == null) {
                d4 = canvas3D.canvasViewCache.getVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.vworldToVpc);
            } else {
                d4 = canvas3D.canvasViewCache.getInfVworldToCoexistenceScale();
                canvas3D.setModelViewMatrix(canvas3D.ctx, canvas3D.vpcToEc.mat, this.renderBin.infVworldToVpc);
            }
            for (int i3 = 0; i3 < this.pointLts.size(); ++i3) {
                LightRetained lightRetained = (LightRetained)this.pointLts.get(i3);
                lightRetained.update(canvas3D.ctx, this.pointLtsSlotIndex[i3], d4);
                canvas3D.lights[this.pointLtsSlotIndex[i3]] = lightRetained;
                canvas3D.frameCount[this.pointLtsSlotIndex[i3]] = n2;
            }
        }
    }
}

